---
generated_at: 2026-02-03 10:10:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：36-next info診断レポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **バージョン比較ロジックの詳細**：parseVersionInfo / getStalenessの内部実装は参照ファイルのみの確認

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/cli/next-info.ts` 行96-169（printInfo関数）
- E-02: `packages/next/src/cli/next-info.ts` 行254-593（printVerboseInfo関数）
- E-03: `packages/next/src/cli/next-info.ts` 行55-61（getPackageVersion関数）
- E-04: `packages/next/src/cli/next-info.ts` 行78-91（getBinaryVersion関数）
- E-05: `packages/next/src/cli/next-info.ts` 行600-608（nextInfo関数）
- E-06: `packages/next/src/cli/next-info.ts` 行14-16（NextInfoOptions型）
- E-07: `packages/next/src/cli/next-info.ts` 行63-72（getNextConfig関数）
- E-08: `packages/next/src/cli/next-info.ts` 行135-162（console.log出力部）
- E-09: `packages/next/src/cli/next-info.ts` 行347-365（Node.js diagnostic report）
- E-10: `packages/next/src/cli/next-info.ts` 行142-145（NEXT_RSPACK対応）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | nextInfo関数がメインエントリ | E-05 | ○ |
| C-02 | --verboseでprintVerboseInfo呼び出し | E-05 | ○ |
| C-03 | OS情報をosモジュールで取得 | E-08 | ○ |
| C-04 | メモリはMath.ceil(totalmem/1024/1024) | E-08（行152） | ○ |
| C-05 | getBinaryVersionでバイナリバージョン取得 | E-04 | ○ |
| C-06 | 失敗時はN/Aを返す | E-03, E-04 | ○ |
| C-07 | npmレジストリからdist-tagsを取得 | E-01（行106-107） | ○ |
| C-08 | 取得失敗時に警告メッセージ表示 | E-01（行120-132） | ○ |
| C-09 | config.outputがN/A表示 | E-07（行67） | ○ |
| C-10 | verbose: Node.js diagnostic reportでcwd等削除 | E-09（行347-351） | ○ |
| C-11 | verbose: プラットフォーム別スクリプト実行 | E-02（行270-531） | ○ |
| C-12 | verbose: ldd/otool/dumpbin.exeで共有ライブラリチェック | E-02（行475-528） | ○ |
| C-13 | NEXT_RSPACK設定時にnext-rspackバージョン表示 | E-10 | ○ |
| C-14 | 陳腐化警告でcanaryバージョン推奨 | E-01（行164-168） | ○ |
| C-15 | parseVersionInfoとgetStalenessの詳細ロジック | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15: parseVersionInfoとgetStalenessの内部実装は別ファイルにあり、参照パスのみ確認
  - 候補：`packages/next/src/server/dev/parse-version-info.ts` / `packages/next/src/next-devtools/shared/version-staleness.ts`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - printInfo/printVerboseInfoのメインフローは確実にソースコードで確認
- 1: 中リスク - バージョン比較ロジックの詳細は別ファイルのため要追加確認

## 6) レビュアーチェックリスト（最小）
- [ ] 出力される環境情報の項目がソースコードと一致するか確認
- [ ] --verboseモードの診断タスク一覧が正確か確認
- [ ] セキュリティ配慮（diagnostic reportからの機密情報削除）が正しく記載されているか確認
